unit FastMMSampleMainFormU;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TMainForm = class(TForm)
    btnMemoryLeak: TButton;
    btnObjectReference: TButton;
    btnInterfaceReference: TButton;
    procedure btnMemoryLeakClick(Sender: TObject);
    procedure btnObjectReferenceClick(Sender: TObject);
    procedure btnInterfaceReferenceClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

type
  IFoo = interface
  ['{1B9E68EC-37DB-42D1-ABCE-B55506DAD27A}']
    procedure SetBar(const Value: Integer);
    function GetBar: Integer;
  end;

  TFoo = class(TInterfacedObject, IFoo)
  private
    FBar: Integer;
    procedure SetBar(const Value: Integer); virtual;
    function GetBar: Integer; virtual;
  public
    property Bar: Integer read GetBar write SetBar;
  end;

var
  Foo: TFoo;

procedure TMainForm.btnMemoryLeakClick(Sender: TObject);
begin
  TStringList.Create;
end;

procedure TMainForm.btnObjectReferenceClick(Sender: TObject);
begin
  if Foo = nil then
    Foo := TFoo.Create;
  Foo.Bar := 57;
  Foo.Free;
end;

procedure TMainForm.btnInterfaceReferenceClick(Sender: TObject);
var
  Foo: TFoo;
  FooI: IFoo;
  FooP: Pointer;
begin
  Foo := TFoo.Create;
  FooI := Foo;
  FooI.SetBar(57);
  FooP := Pointer(FooI);
  FooI := nil;
  //Foo.Free;
  FooI := IFoo(FooP);
  FooI.SetBar(99);
end;

{ TFoo }

function TFoo.GetBar: Integer;
begin
  Result := FBar;
end;

procedure TFoo.SetBar(const Value: Integer);
begin
  FBar := Value;
end;

end.
